// STLport config file for PalmSource's PalmOS targeted C/C++ Compiler

#ifdef __PALMOS__

# include <config/stl_palmos.h>

#else

// Headers
# define _STLP_NATIVE_C_HEADER(x) <##x##>

// Threading
# define _NOTHREADS 1
# define _STLP_NO_THREADS 1

// Wide-char stuff
# define _STLP_NO_NATIVE_WIDE_STREAMS 1
//#define _STLP_NO_WCHAR_T 1
//#define _STLP_NO_MBSTATE_T 1
# define _STLP_WCHAR_BORLAND_EXCLUDE 1

// Iostreams
# define _STLP_OWN_IOSTREAMS
# define _STLP_USE_STDIO_IO 1
# define _STLP_NO_STAT 1

// Namespace
# define _STLP_NO_OWN_NAMESPACE 1

// Allocation
# if !defined(_STLP_USE_NEWALLOC) && !defined(_STLP_USE_MALLOC)
// Use malloc unless somebody wanted something else
#  define _STLP_USE_MALLOC 1
# endif

// Other stuff

#define _STLP_NO_LONG_LONG_VOID_PTR_CAST 1

//#define _STLP_DEBUG 1

# ifndef __EXCEPTIONS
#  define _STLP_NO_EXCEPTIONS 1
# endif
# define _STLP_LONG_LONG long long
# define _STLP_HAS_NO_NEW_C_HEADERS 1

// c_locale.h has the correct definitions for PalmOS 6

# define _Locale_SPACE 0
# define _Locale_PRINT 0
# define _Locale_CNTRL 0
# define _Locale_UPPER 0
# define _Locale_LOWER 0
# define _Locale_ALPHA 0
# define _Locale_DIGIT 0
# define _Locale_PUNCT 0
# define _Locale_XDIGIT 0

#endif /* !__PALMOS__ */                                 
